package examples.entity.intro;

import javax.naming.Context;
import javax.naming.InitialContext;

/**
 * Sample client code for an Account entity that is accessed through
 * a stateful session bean facade.
 */
public class ConflictingClient {
    static Bank bank = null;
    static int num = 13;
    
    static class SecondClientThread extends Thread {
        public void run() {
            System.out.println("Withdrawing... " );
            try {
                bank.withdraw(num, 100000);
            } catch (Exception e) {
                //System.out.println("Exception: " + e.getMessage());
            } 
            System.out.println("Balance = " + bank.getBalance(num));
        }
    }
    
    static class FirstClientThread extends Thread {
        public void run() {            
            bank.printBigAccounts();
        }
    }
    
    public static void main(String[] args)  {       
        try {
            Context ctx = new InitialContext(System.getProperties());
            bank = (Bank)ctx.lookup(Bank.class.getName());
            bank.openAccount("blub", num);
            bank.deposit(num, 100000); 
            
            Thread fst = new FirstClientThread();
            Thread scn = new SecondClientThread();
            fst.start();
            scn.start();
                        
            fst.join();
            scn.join();
            
            System.out.println("Balance = " + bank.getBalance(num));            
        } catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        } 
    }
}
